/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.python.indexer.Def;
import org.python.indexer.Ref;
import org.python.indexer.ast.NNode;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBinding
implements Comparable<Object> {
    private static final int PROVISIONAL = 1;
    private static final int STATIC = 2;
    private static final int SYNTHETIC = 4;
    private static final int READONLY = 8;
    private static final int DEPRECATED = 16;
    private static final int BUILTIN = 32;
    private static final int DEF_SET_INITIAL_CAPACITY = 1;
    private static final int REF_SET_INITIAL_CAPACITY = 8;
    private String name;
    private String qname;
    private NType type;
    Kind kind;
    int modifiers;
    private List<Def> defs;
    private Set<Ref> refs;

    public NBinding(String string, NNode nNode, NType nType, Kind kind) {
        this(string, nNode != null ? new Def(nNode) : null, nType, kind);
    }

    public NBinding(String string, Def def, NType nType, Kind kind) {
        if (string == null) {
            throw new IllegalArgumentException("'id' param cannot be null");
        }
        this.qname = this.name = string;
        this.defs = new ArrayList<Def>(1);
        this.addDef(def);
        this.type = nType == null ? new NUnknownType() : nType;
        this.kind = kind == null ? Kind.SCOPE : kind;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setQname(String string) {
        this.qname = string;
    }

    public String getQname() {
        return this.qname;
    }

    public void addDef(NNode nNode) {
        if (nNode != null) {
            this.addDef(new Def(nNode));
        }
    }

    public void addDefs(Collection<NNode> collection) {
        for (NNode nNode : collection) {
            this.addDef(nNode);
        }
    }

    public void addDef(Def def) {
        if (def == null) {
            return;
        }
        List<Def> list = this.getDefs();
        if (list.contains(def)) {
            return;
        }
        list.add(def);
        def.setBinding(this);
        if (def.isURL()) {
            this.markBuiltin();
        }
    }

    public void addRef(NNode nNode) {
        this.addRef(new Ref(nNode));
    }

    public void addRef(Ref ref) {
        this.getRefs().add(ref);
    }

    public void removeRef(Ref ref) {
        this.getRefs().remove(ref);
    }

    public Def getSignatureNode() {
        return this.getDefs().isEmpty() ? null : this.getDefs().get(0);
    }

    public void setType(NType nType) {
        this.type = nType;
    }

    public NType getType() {
        return this.type;
    }

    public NType followType() {
        return NUnknownType.follow(this.type);
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void markStatic() {
        this.modifiers |= 2;
    }

    public boolean isStatic() {
        return (this.modifiers & 2) != 0;
    }

    public void markSynthetic() {
        this.modifiers |= 4;
    }

    public boolean isSynthetic() {
        return (this.modifiers & 4) != 0;
    }

    public void markReadOnly() {
        this.modifiers |= 8;
    }

    public boolean isReadOnly() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isDeprecated() {
        return (this.modifiers & 0x10) != 0;
    }

    public void markDeprecated() {
        this.modifiers |= 0x10;
    }

    public boolean isBuiltin() {
        return (this.modifiers & 0x20) != 0;
    }

    public void markBuiltin() {
        this.modifiers |= 0x20;
    }

    public void setProvisional(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 1) : (this.modifiers &= 0xFFFFFFFE);
    }

    public boolean isProvisional() {
        return (this.modifiers & 1) != 0;
    }

    @Override
    public int compareTo(Object object) {
        return this.getSignatureNode().start() - ((NBinding)object).getSignatureNode().start();
    }

    public List<Def> getDefs() {
        if (this.defs == null) {
            this.defs = new ArrayList<Def>(1);
        }
        return this.defs;
    }

    public int getNumDefs() {
        return this.defs == null ? 0 : this.defs.size();
    }

    public boolean hasRefs() {
        return this.refs == null ? false : !this.refs.isEmpty();
    }

    public int getNumRefs() {
        return this.refs == null ? 0 : this.refs.size();
    }

    public Set<Ref> getRefs() {
        if (this.refs == null) {
            this.refs = new LinkedHashSet<Ref>(8);
        }
        return this.refs;
    }

    public String getFirstFile() {
        NType nType = this.getType();
        if (nType instanceof NModuleType) {
            String string = nType.asModuleType().getFile();
            return string != null ? string : "<built-in module>";
        }
        if (this.defs != null) {
            for (Def def : this.defs) {
                String string = def.getFile();
                if (string == null) continue;
                return string;
            }
            return "<built-in binding>";
        }
        return "<unknown source>";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<Binding:").append(this.qname);
        stringBuilder.append(":type=").append(this.type);
        stringBuilder.append(":kind=").append((Object)this.kind);
        stringBuilder.append(":defs=").append(this.defs);
        stringBuilder.append(":refs=");
        if (this.getRefs().size() > 10) {
            stringBuilder.append("[");
            stringBuilder.append(this.refs.iterator().next());
            stringBuilder.append(", ...(");
            stringBuilder.append(this.refs.size() - 1);
            stringBuilder.append(" more)]");
        } else {
            stringBuilder.append(this.refs);
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ATTRIBUTE,
        CLASS,
        CONSTRUCTOR,
        FUNCTION,
        METHOD,
        MODULE,
        PARAMETER,
        SCOPE,
        VARIABLE;

    }
}

